<?php
// Load WordPress functions
require_once('../../../../wp-load.php');
// Variables
$themes_dir_path = get_theme_root() . '/';
$download_url = esc_url($_POST["download_url"]);
$theme_name = esc_html($_POST["theme_name"]);
$theme_slug = esc_html($_POST["theme_slug"]);
if (isset($_POST["modal_install"])) {
    $modal_install = $_POST["modal_install"];
}
if (isset($_POST["premium_install"])) {
    $premium_install = $_POST["premium_install"];
}
$theme_zip = $theme_slug . '.zip';
$theme_zip_path = $themes_dir_path . $theme_zip;
$theme_dir = $themes_dir_path . $theme_slug;
$nonce_url = add_query_arg(
    array(
        'action' => 'activate',
        'stylesheet'  => urlencode( $theme_slug ),
    ),
    admin_url( 'themes.php' )
);
$nonce_url = wp_nonce_url( $nonce_url, 'switch-theme_' . $theme_slug );
// Error message
if ( file_exists($theme_dir) ) {
    if (isset($modal_install)) {
        echo '<a href="' . admin_url( 'themes.php' ) . '" class="button button-primary button-hero disabled" title="' . esc_attr__('You already installed', 'themely') . ' ' . esc_html($theme_name) . '">' . esc_html__('Installed', 'themely') . '</a>';
    } else if (isset($premium_install)) {
        echo '<div id="alert" class="alert alert-themely"><strong>' . esc_html($theme_name) .'</strong> ' . esc_html__('theme already installed,', 'themely') . ' <a href="' . admin_url('themes.php') . '">' . esc_html__('visit this page to activate', 'themely') . '</a> ' . esc_html__('or choose another theme.', 'themely') . '</div>';
    } else {
        echo '<a href="' . admin_url( 'themes.php' ) . '" class="w-100 text-center button button-hero button-buy disabled" title="' . esc_attr__('You already installed', 'themely') . ' ' . esc_html($theme_name) . '">' . esc_html__('Installed', 'themely') . '</a>';
        exit;
    }
} else {
    // Download zip file
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $download_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    // Save zip file
    $file = fopen($theme_zip_path, 'w+');
    fwrite($file, $result);
    fclose($file);
    // Extract zip file
    $zip = new ZipArchive;         
    $zip->open($theme_zip_path);
    $zip->extractTo($themes_dir_path);
    $zip->close();
    // Remove zip file
    unlink($theme_zip_path);
    // Success message
    if ( isset($modal_install) ) {
        echo '<a href="' . esc_url($nonce_url) . '" class="button button-primary button-hero focus" title="' . esc_attr__('Activate', 'themely') . ' ' . esc_html($theme_name) . '">' . esc_html__('Activate', 'themely') . '</a>';
    } else if ( isset($premium_install) ) {
        echo '<div id="alert" class="alert alert-themely"><strong>' . esc_html($theme_name) . '</strong> ' . esc_html__('successfully purchased and installed! A purchase receipt was sent to your email address.', 'themely') . ' <a href="' . esc_url($download_url) . '">' . esc_html__('Download a backup copy', 'themely') . '</a> ' . esc_html__('then', 'themely') . ' <a href="' . esc_url($nonce_url) . '">' . esc_html__('activate', 'themely') . ' ' . esc_html($theme_name) . '</a> ' . esc_html__('to begin using your new theme.', 'themely') . '</div>';
    } else {
        echo '<a href="' . esc_url($nonce_url) . '" class="w-100 text-center button button-primary button-hero button-buy" title="' . esc_attr__('Activate', 'themely') . ' ' . esc_html($theme_name) . '">' . esc_html__('Activate', 'themely') . '</a>';
    }
}